/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.analyzer.perspectives;

import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.CheckForNull;
import org.sonar.api.batch.fs.InputPath;
import org.sonar.api.component.Perspective;
import org.sonar.api.component.ResourcePerspectives;
import org.sonar.api.resources.Resource;
import org.sonarsource.sonarlint.core.analyzer.perspectives.PerspectiveBuilder;
import org.sonarsource.sonarlint.core.analyzer.perspectives.PerspectiveNotFoundException;

public class BatchPerspectives
implements ResourcePerspectives {
    private final Map<Class<?>, PerspectiveBuilder<?>> builders = Maps.newHashMap();

    public BatchPerspectives(PerspectiveBuilder[] builders) {
        for (PerspectiveBuilder builder : builders) {
            this.builders.put(builder.getPerspectiveClass(), builder);
        }
    }

    @Override
    @CheckForNull
    public <P extends Perspective> P as(Class<P> perspectiveClass, Resource resource) {
        return null;
    }

    @Override
    public <P extends Perspective> P as(Class<P> perspectiveClass, InputPath inputPath) {
        PerspectiveBuilder<P> builder = this.builderFor(perspectiveClass);
        return builder.loadPerspective(perspectiveClass, inputPath);
    }

    private <T extends Perspective> PerspectiveBuilder<T> builderFor(Class<T> clazz) {
        PerspectiveBuilder<?> builder = this.builders.get(clazz);
        if (builder == null) {
            throw new PerspectiveNotFoundException("Perspective class is not registered: " + clazz);
        }
        return builder;
    }
}

